import type { Runtime } from '../manager/types';
export interface DevToolsInfo {
    url: string;
    timestamp: string;
}
export declare function findProjectRoot(): Promise<string>;
export declare function findRuntimesDir(projectRoot: string): Promise<string>;
export declare function findServersDir(projectRoot: string): Promise<string>;
export declare function projectNameFromGenkitFilePath(filePath: string): string;
export declare function detectRuntime(directory: string): Promise<Runtime>;
export declare function checkServerHealth(url: string): Promise<boolean>;
export declare function waitUntilHealthy(url: string, maxTimeout?: number): Promise<boolean>;
export declare function waitUntilUnresponsive(url: string, maxTimeout?: number): Promise<boolean>;
export declare function retriable<T>(fn: () => Promise<T>, opts: {
    maxRetries?: number;
    delayMs?: number;
}): Promise<T>;
export declare function isValidDevToolsInfo(data: any): data is DevToolsInfo;
export declare function writeToolsInfoFile(url: string, projectRoot: string): Promise<void>;
export declare function removeToolsInfoFile(fileName: string, projectRoot: string): Promise<void>;
